---
generated_at: 2026-02-05 10:25:00
metrics:
  claims_total: 12
  claims_with_evidence: 10
  claims_without_evidence: 2
confidence_derived: 0.83
---

# 根拠レポート：6-Backport Label Audit

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.83**
  - 根拠あり：10 / 12、根拠なし：2
- 優先レビュー（高）
  1. **外部ワークフローの具体的な監査処理内容**：audit.ymlの実装詳細は外部リポジトリに依存
  2. **バックポート状態確認のロジック**：具体的な判定方法は外部ワークフロー内の実装に依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.github/workflows/backport-label-audit.yml`
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv`（No.6行）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | workflow_dispatchによる手動実行 | E-01（on: workflow_dispatch） | ○ |
| C-02 | versionパラメータ（オプション、String型） | E-01（inputs: version） | ○ |
| C-03 | dry_runパラメータ（必須、Choice型、デフォルト'true'） | E-01（inputs: dry_run） | ○ |
| C-04 | dry_runの選択肢は'true'と'false' | E-01（options: true/false） | ○ |
| C-05 | 外部ワークフローaudit.ymlをuses句で呼び出し | E-01（uses: JuliaLang/backporter-github-actions-workflows/...） | ○ |
| C-06 | コミットハッシュf0cf777aで固定 | E-01（@f0cf777a...） | ○ |
| C-07 | permissionsはpull-requests: write | E-01（permissions: pull-requests: write） | ○ |
| C-08 | versionとdry_runを外部ワークフローに渡す | E-01（with: version, dry_run） | ○ |
| C-09 | バージョン未指定時は全バージョン対象 | E-01（description: 'Leave empty to audit all versions.'） | ○ |
| C-10 | ワークフロー名は"Backport Label Audit" | E-01（name: Backport Label Audit） | ○ |
| C-11 | バックポートラベル付きPRの検索と状態確認 | **根拠なし**（外部ワークフローの実装に依存） | △ |
| C-12 | バックポート完了済みPRからラベルを除去 | **根拠なし**（外部ワークフローの実装に依存） | △ |

## 4) 不足情報（Unknown / Missing）
- C-11, C-12の外部ワークフローの具体的な実装は、JuliaLang/backporter-github-actions-workflowsリポジトリのaudit.ymlを参照する必要がある
  - 候補：JuliaLang/backporter-github-actions-workflows/.github/workflows/audit.yml

## 5) リスクフラグ（レビュー観点）
- C-11, C-12: 1（中リスク）- 外部ワークフローの具体的な動作が確認できないため、設計書の記述が推測に基づいている

## 6) レビュアーチェックリスト（最小）
- [ ] 外部ワークフロー（backporter-github-actions-workflows/audit.yml）の実際の動作と設計書の記述が一致しているか確認
- [ ] dry_runのデフォルト値が'true'であることが正しく記載されているか確認
- [ ] 入力パラメータの型と必須/任意が正しく記載されているか確認
